' sap-script-dpi.vbs - Opens DPI files from SAP ZPACK transaction

On Error Resume Next

' Set scripting mode to true
Set WSHShell = CreateObject("WScript.Shell")

' Disable SAP GUI scripting warnings in registry
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAttach", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnConnection", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\WarnOnAllowListRequired", 0, "REG_DWORD"
WSHShell.RegWrite "HKEY_CURRENT_USER\Software\SAP\SAPGUI Front\SAP Frontend Server\Security\UseAllowList", 0, "REG_DWORD"

' Get material number from command line argument
materialNumber = WScript.Arguments.Item(0)

' Declare log file object and path
Dim logFile, logFilePath

' Initialize log file if path is provided
If WScript.Arguments.Count > 1 Then
    logFilePath = WScript.Arguments.Item(1)
    ' Try to open the log file in append mode (8)
    On Error Resume Next
    Set fso = CreateObject("Scripting.FileSystemObject")
    Set logFile = fso.OpenTextFile(logFilePath, 8, True)
    
    If Err.Number <> 0 Then
        WScript.Echo "ERROR: Could not open log file: " & Err.Description
        Err.Clear
        Set logFile = Nothing
    Else
        ' Log script start
        LogToFile "========================================="
        LogToFile "Script Started at " & Now
        LogToFile "Script: " & WScript.ScriptName
        LogToFile "Material Number: " & materialNumber
        LogToFile "========================================="
    End If
End If

' Function to log message to file
Sub LogToFile(message)
    On Error Resume Next
    If Not logFile Is Nothing Then
        logFile.WriteLine Now & " - [" & WScript.ScriptName & "] - " & message
    End If
End Sub

' Function to log message to both console and file
Sub LogMessage(message)
    WScript.Echo message
    LogToFile message
End Sub

' SAP connection code
If Not IsObject(application) Then
   Set SapGuiAuto  = GetObject("SAPGUI")
   Set application = SapGuiAuto.GetScriptingEngine
End If
If Not IsObject(connection) Then
   Set connection = application.Children(0)
End If
If Not IsObject(session) Then
   Set session    = connection.Children(0)
End If
If IsObject(WScript) Then
   WScript.ConnectObject session,     "on"
   WScript.ConnectObject application, "on"
End If

' Handle security dialog
Sub HandleSecurityDialog()
    Dim shell, timeout, dialogFound
    Set shell = CreateObject("WScript.Shell")
    timeout = 0
    dialogFound = False
    
    Do While timeout < 10
        If shell.AppActivate("SAP GUI Security") Then
            WScript.Sleep 500
            shell.SendKeys " "  ' Press space to check "Remember my decision"
            WScript.Sleep 200
            shell.SendKeys "{ENTER}"  ' Press Enter to click Allow
            dialogFound = True
            Exit Do
        End If
        WScript.Sleep 500
        timeout = timeout + 1
    Loop
End Sub

' Call HandleSecurityDialog before starting operations
HandleSecurityDialog()

' Open ZPACK transaction
session.findById("wnd[0]").maximize
session.findById("wnd[0]/tbar[0]/okcd").text = "zpack"
session.findById("wnd[0]").sendVKey 0

' Enter material number and execute search
session.findById("wnd[0]/usr/ctxtS_MATNR-LOW").text = materialNumber
session.findById("wnd[0]").sendVKey 8

' Get the file list table
Set fileTable = session.findById("wnd[0]/usr/tabsTAB_9100/tabpTAB_9100_FC3/ssubTAB_9100_SCA:ZDGP_MATERIAL_OVERVIEW:9103/cntlCONTROL_9103_2/shellcont/shell")

foundDPI = False
dpiRowIndex = -1
foundFileName = ""

' Loop through the files to find one with "DPI" in its name
For i = 0 To fileTable.RowCount - 1
    fileName = fileTable.GetCellValue(i, "DOKNR") ' Adjust column ID if needed
    
    If InStr(1, fileName, "DPI", vbTextCompare) > 0 Then
        foundDPI = True
        dpiRowIndex = i
        foundFileName = fileName
        Exit For
    End If
Next

' Check results and take appropriate action
If foundDPI Then
    ' If DPI file found, open it
    fileTable.setCurrentCell dpiRowIndex, "DOKNR" ' Adjust column ID if needed
    fileTable.selectedRows = dpiRowIndex
    fileTable.doubleClickCurrentCell
    
    ' Wait for the document viewer to open
    WScript.Sleep 3000
    
    ' Return success with filename
    LogMessage "SUCCESS: " & foundFileName
    
    ' Note: No going back, let the document remain open and SAP stay on the document list screen
    
Else
    ' Return nothing found status
    LogMessage "NOT-FOUND"
End If

' Add at the end of your script before it exits
Sub CloseLogFile()
    On Error Resume Next
    If Not logFile Is Nothing Then
        LogToFile "Script ended at " & Now
        LogToFile "========================================="
        logFile.Close
        Set logFile = Nothing
    End If
End Sub

' At the end of the script, add:
CloseLogFile()